# Next.js + MySQL Demo

This is a minimal Next.js demo app with a MySQL connection and a demo API.

## Setup

1. Copy `.env.example` to `.env.local` and fill in your MySQL credentials.
2. Install dependencies:
   ```bash
   npm install
   ```
3. Create the sample database (run in your MySQL server):
   ```sql
   CREATE DATABASE IF NOT EXISTS next_demo;
   USE next_demo;
   CREATE TABLE IF NOT EXISTS users (
     id INT AUTO_INCREMENT PRIMARY KEY,
     name VARCHAR(100),
     email VARCHAR(100)
   );
   INSERT INTO users (name, email) VALUES ('Alice','alice@example.com'),('Bob','bob@example.com');
   ```
4. Run in development:
   ```bash
   npm run dev
   ```
5. Open http://localhost:3000 and click "Load Users"

## Files
- `lib/db.js` - MySQL connection pool using `mysql2/promise`
- `pages/api/users.js` - GET and POST API for users
- `pages/index.js` - Demo UI to list users and add a user
