"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
0 && (module.exports = {
    normalizeAppPath: null,
    normalizeRscURL: null,
    normalizePostponedURL: null
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    normalizeAppPath: function() {
        return normalizeAppPath;
    },
    normalizeRscURL: function() {
        return normalizeRscURL;
    },
    normalizePostponedURL: function() {
        return normalizePostponedURL;
    }
});
const _ensureleadingslash = require("../../page-path/ensure-leading-slash");
const _segment = require("../../segment");
const _url = require("url");
function normalizeAppPath(route) {
    return (0, _ensureleadingslash.ensureLeadingSlash)(route.split("/").reduce((pathname, segment, index, segments)=>{
        // Empty segments are ignored.
        if (!segment) {
            return pathname;
        }
        // Groups are ignored.
        if ((0, _segment.isGroupSegment)(segment)) {
            return pathname;
        }
        // Parallel segments are ignored.
        if (segment[0] === "@") {
            return pathname;
        }
        // The last segment (if it's a leaf) should be ignored.
        if ((segment === "page" || segment === "route") && index === segments.length - 1) {
            return pathname;
        }
        return pathname + "/" + segment;
    }, ""));
}
function normalizeRscURL(url) {
    return url.replace(/\.rsc($|\?)/, // $1 ensures `?` is preserved
    "$1");
}
function normalizePostponedURL(url) {
    const parsed = (0, _url.parse)(url);
    let { pathname } = parsed;
    if (pathname && pathname.startsWith("/_next/postponed")) {
        pathname = pathname.substring("/_next/postponed".length) || "/";
        return (0, _url.format)({
            ...parsed,
            pathname
        });
    }
    return url;
}

//# sourceMappingURL=app-paths.js.map